/***************************************************************
 *                    simula+@metz.ensam.fr                    *
 *	             GNU/linux version 2.0.0                   *
 *            software under General Public License            *
 ***************************************************************
 * copyright  2003,2004,2005,2006,2007,2008 COLLARD Christophe
 * copyright  2003,2004,2005,2006,2007,2008 Laboratoire de Physique et Mcanique des Matriaux (LPMM - UMR 7554)
 * copyright  2003,2004,2005,2006,2007 Laboratoire de Mathmatiques et ses Applications de Valenciennes (LAMAV - EA 4015)
 ***************************************************************/

/*
    isotropic tensors-tests belongs to Materials Object Libraries (MateriOL++)
    MateriOL++ is part of Simula+

    Simula+ is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    Simula+ is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with Simula+; if not, write to the Free Software
    Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

#ifndef __cplusplus
#error Must use C++ for the type isotropic tensors test
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_TEST_H)
#define __ISOTROPIC_ELASTICITY_TENSORS_TEST_H


#if !defined (__IOSTREAM_H)
#include <iostream>
#endif

#if !defined(__STDIO_H)
#include <stdio.h>
#endif

#if !defined(__STDLIB_H)
#include <stdlib.h>
#endif

#if !defined(__PARAMETERS_H)
#include "parameters.h"
#endif

#if !defined(__ISOTROPIC_ELASTICITY_TENSORS_H)
#include"MateriOL++/isotropic elasticity tensors.h"
#endif

#if !defined(__AFFICHE_h)
#include "tests/affiche.h"
#endif

using namespace materiol;


//===============================================
int test_isotropic_elasticity_tensor (int detail)
//===============================================
{
  bool result = true;

  long double eps = epsilon;
  epsilon = 1.e-10; // change precision level for computations

  long double lambda=60000, mu=40000, E=104000, nu=.3, K=86666.666666666667;
  isotropic_elasticity_tensor<long double> C("elasticity tensor"), S, C0, C1, C2, C3, C4;
  C.Lame(lambda);
  C.Shear(mu);

  tensor4<long double> Ct(3), St(3);

  bool test;

  if (detail) affiche ("material's constants", C.Lame()==60000 && C.Shear()==40000 && C.Young()==E && abs(C.Poisson()-nu)<epsilon && abs(C.Bulk()-K)<10*epsilon);
  else result *= (C.Lame()==60000 && C.Shear()==40000 && C.Young()==E && abs(C.Poisson()-nu)<epsilon && abs(C.Bulk()-K)<epsilon);

  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  {
	    Ct(i,j,k,l) = lambda * (i==j) * (k==l) + mu * ( (i==k) * (j==l) + (i==l) * (j==k));
	    test *= (abs( C(i,j,k,l) - lambda * (i==j) * (k==l) - mu * ( (i==k) * (j==l) + (i==l) * (j==k)) ) < epsilon * 10.);
	  }
  test = (C == Ct);
  C0.Lame(2*lambda);
  C0.Shear(2*mu);
  C0.Shear(mu);
  C0.Lame(lambda);
  test *= (C == C0);

  C1.Lame(lambda);
  C1.Poisson(nu);
  test *= (C==C1);

  C2.Lame(lambda);
  C2.Bulk(K);
  test *= (C == C2);

  C3.lambda(lambda);
  C3.Poisson(nu);
  test *= (C==C3);

  C4.mu(mu);
  C4.lambda(lambda);
  test *= (C==C4);

  if (detail) affiche ("Lame", test);
  else result *= (test);

//----------------------------------------------------------------------------------------------------------------------------------------

  isotropic_elasticity_tensor<long double> C01, C02, C03, C04;

  C01.Shear(mu);
  C01.Lame(lambda);
  test = (C01 == C);

  C02.Shear(mu);
  C02.Young(E);
  test *= (C02 == C);

  C03.Shear(mu);
  C03.Poisson(nu);
  test *= (C03 == C);

  C04.Shear(mu);
  C04.Bulk(K);
  test *= (C04 == C);

  if (detail) affiche ("Shear", test);
  else result *= (test);


//----------------------------------------------------------------------------------------------------------------------------------------

  isotropic_elasticity_tensor<long double> C11, C12, C13;

  C11.Young(E);
  C11.Shear(mu);
  test = (C11 == C);

  C12.Young(E);
  C12.Poisson(nu);
  test *= (C12 == C);

  C13.Young(E);
  C13.Bulk(K);
  test *= (C13 == C);

  if (detail) affiche ("Young", test);
  else result *= (test);

//----------------------------------------------------------------------------------------------------------------------------------------

  isotropic_elasticity_tensor<long double> C21, C22, C23, C24;

  C21.Poisson(nu);
  C21.Lame(lambda);
  test = (C == C21);

  C22.Poisson(nu);
  C22.Shear(mu);
  test *= (C22 == C);

  C23.Poisson(nu);
  C23.Young(E);
  test *= (C23 == C);

  C24.Poisson(nu);
  C24.Bulk(K);
  test *= (C24 == C);

  if (detail) affiche ("Poisson", test);
  else result *= (test);

//----------------------------------------------------------------------------------------------------------------------------------------

  isotropic_elasticity_tensor<long double> C31, C32, C33, C34;

  C31.Bulk(K);
  C31.Lame(lambda);
  test = (C31 == C);

  C32.Bulk(K);
  C32.Shear(mu);
  test *= (C32 == C);

  C33.Bulk(K);
  C33.Young(E);
  test *= (C33 == C);

  C34.Bulk(K);
  C34.Poisson(nu);
  test *= (C34 == C);

  if (detail) affiche ("Bulk", test);
  else result *= (test);

//----------------------------------------------------------------------------------------------------------------------------------------

  vector<long double> lame(2);
  lame[1] = C.Lame();
  lame[2] = C.Shear();
  if (detail) affiche ("elastic constants", C.elastic_constants() == lame);
  else result *= (C.elastic_constants() == lame);

  S = C;
  S.name("stiffness tensor");
  S.lambda(-1.*lambda/(2*mu)/(3*lambda+2*mu));
  S.mu(1/(4*mu));
  long double sum = 0;
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  {
	    St(i,j,k,l) = 0.25 / mu * ( (i==k) * (j==l) + (i==l) * (j==k) ) - lambda / (2.*mu * (3.*lambda + 2.*mu)) * (i==j) * (k==l);
	    sum += C(i,j,k,l) * S(i,j,k,l);
	  }
  if (detail) affiche ("isotropic stiffness tensor", abs(sum/6.-1.)<epsilon && S==St);
  else result *= (abs(sum/6.-1.)<epsilon && S==St);

  if (detail) affiche ("Young's modulus", C.Young()==104000.);
  else result *= C.Young()==104000.;

  if (detail) affiche ("Poisson's ratio", abs(C.Poisson()-.3)<epsilon);
  else result *= abs(C.Poisson()-.3)<epsilon;

  if (detail) affiche ("bulk modulus", abs(C.Bulk() - 60000. - 80000./3.) < 5e-12);
  else result *=  abs(C.Bulk() - 60000. - 80000./3.) < 5e-12;

  tensor4<long double> S1 = C.inv();
  if (detail) affiche ("inv", S1==S);
  else result *=  (S1==S);

  matrix<long double> P(3,3);
  matrix<long double> passlg(3,3); // orthogonal matrix
  tensor4<long double> tsr(3);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      P(i,j) = (2.52*i - 1.25*j + 25 * (i==j)) * 1E-2;
  long double phi1=173.464, phi=104.504, phi2=34.5;
  passlg(1,1) =  cos(phi1) * cos(phi2)  -  sin(phi1) * cos(phi) * sin(phi2);
  passlg(1,2) = -cos(phi1) * sin(phi2)  -  sin(phi1) * cos(phi) * cos(phi2);
  passlg(1,3) =  sin(phi1) * sin(phi);
  passlg(2,1) =  sin(phi1) * cos(phi2)  +  cos(phi1) * cos(phi) * sin(phi2);
  passlg(2,2) = -sin(phi1) * sin(phi2)  +  cos(phi1) * cos(phi) * cos(phi2);
  passlg(2,3) = -cos(phi1) * sin(phi);
  passlg(3,1) =  sin(phi)  * sin(phi2);
  passlg(3,2) =  sin(phi)  * cos(phi2);
  passlg(3,3) =  cos(phi);
  for (int i=1; i<=3; i++)
    for (int j=1; j<=3; j++)
      for (int k=1; k<=3; k++)
	for (int l=1; l<=3; l++)
	  for (int p=1; p<=3; p++)
	    for (int q=1; q<=3; q++)
	      for (int m=1; m<=3; m++)
		for (int n=1; n<=3; n++)
		  tsr(p,q,m,n) += P(p,i) * P(q,j) * P(m,k) * P(n,l) * C(i,j,k,l);
  long double scalar = .1;
  test = true;
  test *= (C == change_basis(passlg,C,true));
  test *= (C*scalar == change_basis(passlg,C)*scalar);
  test *= (tsr == change_basis(P,C));
  if (detail) affiche ("change basis", test);
  else result *= test;

  tensor4<long double> T;
  T = C;
  isotropic_elasticity_tensor<long double> TC;
  TC = T;
  if (detail) affiche ("cast conversion : tensor4 -> isotropic_elasticity_tensor", TC==C && TC.Lame()==lambda && TC.Shear()==mu);
  else result *=  (TC==C && TC.Lame()==lambda && TC.Shear()==mu);

  isotropic_tensor<long double> Ti;
  isotropic_elasticity_tensor<long double> Tie;
  Ti.lambda(60000);
  Ti.mu(40000);
  Tie = Ti;
  if (detail) affiche ("cast conversion : isotropic_tensor -> isotropic_elasticity_tensor", Tie==C && Tie.Lame()==lambda && Tie.Shear()==mu);
  else result *=  (Tie==C && Tie.Lame()==lambda && Tie.Shear()==mu);

  cout << endl;

  epsilon = eps; // restore precision level for computations

  cout << "============================================================== \n";
  if (result) cout<< "            isotropic elasticity tensor test passed \n";
  else cout << "            isotropic elasticity tensor test failed \n";
  cout << "============================================================== \n";

  return result;
}


#endif
